---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：91-Google Cloud設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **フロントエンドVue.jsコンポーネントの実装詳細**：根拠不足
  2. **CloudSeed機能の全体像**：根拠不足
  3. **サービスアカウントサービスの実装詳細**：コードファイル未読込

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/google_cloud/configuration/index.html.haml`（1-5行）
- E-02: `app/controllers/projects/google_cloud/configuration_controller.rb`（1-39行）
- E-03: `app/controllers/projects/google_cloud/base_controller.rb`（1-78行）
- E-04: `config/routes/project.rb`（310-330行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（132-133行）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（92行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/google_cloud/configuration` | E-04 | ○ |
| C-02 | コントローラー: `Projects::GoogleCloud::ConfigurationController#index` | E-02 | ○ |
| C-03 | 画面データはJSON形式でjs_dataとして渡される | E-01, E-02 | ○ |
| C-04 | admin_project_google_cloud権限が必要 | E-03 (12-16行) | ○ |
| C-05 | Google OAuth2がGitLabで有効化されている必要がある | E-03 (19-24行) | ○ |
| C-06 | サービスアカウント一覧を取得する | E-02 (11行) | ○ |
| C-07 | GCPリージョン設定をCI変数から取得 | E-02 (25-29行) | ○ |
| C-08 | OAuth認証取り消しURLはトークンが有効な場合のみ設定 | E-02 (31-35行) | ○ |
| C-09 | 関連機能No.60 Kubernetesクラスター連携 | E-05 | ○ |
| C-10 | ビューはVue.jsコンポーネントで実装 | E-01 | ○ |
| C-11 | Ci::VariablesFinderでCI変数を検索 | E-02 (27行) | ○ |
| C-12 | GoogleApi::CloudPlatform::Clientでトークン検証 | E-02, E-03 | ○ |
| C-13 | デプロイメント設定画面へのURLを提供 | E-02 (9行) | ○ |
| C-14 | データベース設定画面へのURLを提供 | E-02 (10行) | ○ |
| C-15 | サービスアカウント作成画面へのURLを提供 | E-02 (12行) | ○ |
| C-16 | GCPリージョン設定画面へのURLを提供 | E-02 (15行) | ○ |
| C-17 | 空状態のイラスト画像パスを設定 | E-02 (13-14行) | ○ |
| C-18 | track_eventでイベントトラッキングを実行 | E-02 (20行), E-03 (56-64行) | ○ |
| C-19 | ルートは/google_cloudから/configurationにリダイレクト | E-04 (311行) | ○ |
| C-20 | BaseControllerを継承している | E-02 (5行) | ○ |
| C-21 | feature_categoryはnot_owned | E-03 (4行) | ○ |
| C-22 | urgencyはlow | E-03 (5行) | ○ |
| C-23 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |
| C-24 | CloudSeedサービスの全体アーキテクチャ | **根拠なし** | △ |
| C-25 | GCP_REGION_CI_VAR_KEYの定数値 | E-02 (26行：参照のみ) | ○ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/projects/google_cloud/` 配下のファイル
- CloudSeedサービスの全体アーキテクチャドキュメントが未参照
  - 候補：`app/services/cloud_seed/` 配下のサービスファイル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーの基本処理フロー
- **0: 低リスク** - 権限チェックロジック
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - サービスアカウントサービスの詳細実装（ファイル未読込）

## 6) レビュアーチェックリスト（最小）
- [ ] Google OAuth2が未設定の場合のエラーメッセージが正しいか確認
- [ ] admin_project_google_cloud権限のポリシー定義が存在するか確認
- [ ] Vue.jsコンポーネントの実装がjs_dataの構造と一致するか確認
- [ ] サービスアカウントサービスの実装が正しいか確認
- [ ] CI変数キー（GCP_REGION_CI_VAR_KEY）の定数定義を確認
